---@meta

---@class IUltra_Dynamic_Weather_Interface_C : IInterface
local IUltra_Dynamic_Weather_Interface_C = {}

---@param Map TMap<UUDS_Weather_Settings_C, double>
IUltra_Dynamic_Weather_Interface_C['Get Local Weather Source Objects'] = function(self, Map) end
---@param Season double
IUltra_Dynamic_Weather_Interface_C['Get Current Season'] = function(self, Season) end
---@param Out double
IUltra_Dynamic_Weather_Interface_C['Get Weather Speed'] = function(self, Out) end
---@param A UUDS_Weather_Settings_C
---@param B UUDS_Weather_Settings_C
---@param alpha double
---@param Target_State UUDS_Weather_Settings_C
---@param Set_Material_Effects boolean
---@param Bias_Material_Effects boolean
---@param Lerp_Sources boolean
---@param Success boolean
IUltra_Dynamic_Weather_Interface_C['Interpolate Weather State'] = function(self, A, B, alpha, Target_State, Set_Material_Effects, Bias_Material_Effects, Lerp_Sources, Success) end
---@param Out TArray<double>
IUltra_Dynamic_Weather_Interface_C['Get Individual Season Floats'] = function(self, Out) end
---@param UDS AUltra_Dynamic_Sky_C
IUltra_Dynamic_Weather_Interface_C['Get UDW Current UDS Reference'] = function(self, UDS) end
---@param Nighttime_Bias double
---@param Daytime__Bias double
---@param Overcast_Bias double
---@param Rain_Bias double
---@param Snow_Bias double
---@param Fog_Bias double
---@param Dust_Bias double
---@param Morning_Evening_Bias double
IUltra_Dynamic_Weather_Interface_C['Get Temperature Bias Settings'] = function(self, Nighttime_Bias, Daytime__Bias, Overcast_Bias, Rain_Bias, Snow_Bias, Fog_Bias, Dust_Bias, Morning_Evening_Bias) end
---@param Above_Freezing boolean
IUltra_Dynamic_Weather_Interface_C['Get Global Temp Above Freezing'] = function(self, Above_Freezing) end
---@param Coverage_Duration double
---@param Clear_Duration double
---@param Clear_Speed__Windy_ double
---@param Clear_Speed__No_Wind_ double
IUltra_Dynamic_Weather_Interface_C['Get Dust Material Change Timing'] = function(self, Coverage_Duration, Clear_Duration, Clear_Speed__Windy_, Clear_Speed__No_Wind_) end
---@param Coverage_Duration double
---@param Dry_Duration double
---@param Dry_Speed__Sunny_ double
---@param Dry_Speed__Cloudy_ double
---@param Snow_Melt_Contributes_to_Wetness double
IUltra_Dynamic_Weather_Interface_C['Get Wetness Material Change Timing'] = function(self, Coverage_Duration, Dry_Duration, Dry_Speed__Sunny_, Dry_Speed__Cloudy_, Snow_Melt_Contributes_to_Wetness) end
---@param Coverage_Duration double
---@param Melt_Duration double
---@param Melt_Speed__Above_Freezing_ double
---@param Melt_Speed__Below_Freezing_ double
IUltra_Dynamic_Weather_Interface_C['Get Snow Material Change Timing'] = function(self, Coverage_Duration, Melt_Duration, Melt_Speed__Above_Freezing_, Melt_Speed__Below_Freezing_) end
---@param Out double
IUltra_Dynamic_Weather_Interface_C['Get UDW Scaled Tick Delta Seconds'] = function(self, Out) end
---@param Angle double
---@param Thunder_Lightning_Threshold double
IUltra_Dynamic_Weather_Interface_C['Global Lightning Managed Spawn'] = function(self, Angle, Thunder_Lightning_Threshold) end
---@param Out FRandomStream
IUltra_Dynamic_Weather_Interface_C['Get UDW Random Stream'] = function(self, Out) end
---@param Out double
IUltra_Dynamic_Weather_Interface_C['Get Lightning Flash Period'] = function(self, Out) end
---@param Success boolean
IUltra_Dynamic_Weather_Interface_C['UDS Reconstruct'] = function(self, Success) end
---@param Delta_Time double
IUltra_Dynamic_Weather_Interface_C['UDW Runtime Tick'] = function(self, Delta_Time) end
---@param Storm AActor
---@param Success boolean
IUltra_Dynamic_Weather_Interface_C['Report Removed Radial Storm'] = function(self, Storm, Success) end
---@param Cloud_Coverage boolean
---@param Fog boolean
---@param Dust boolean
IUltra_Dynamic_Weather_Interface_C['Get UDS Weather Override Bool'] = function(self, Cloud_Coverage, Fog, Dust) end
---@param Override_Clouds boolean
---@param Cloud_Coverage double
---@param Override_Fog boolean
---@param Fog double
---@param Override_Dust boolean
---@param Dust double
---@param Success boolean
IUltra_Dynamic_Weather_Interface_C['UDS Weather Variable Overrides'] = function(self, Override_Clouds, Cloud_Coverage, Override_Fog, Fog, Override_Dust, Dust, Success) end
---@param Cloud_Coverage double
---@param Fog double
---@param Dust_Amount double
---@param Cloud_Direction double
---@param Wind_Speed_Multiplier double
---@param Fog_Vertical_Velocity double
IUltra_Dynamic_Weather_Interface_C['Get UDS Values Controlled by UDW'] = function(self, Cloud_Coverage, Fog, Dust_Amount, Cloud_Direction, Wind_Speed_Multiplier, Fog_Vertical_Velocity) end
---@param Editor_Camera_Location FVector
---@param Editor_Camera_Rotation FRotator
---@param Delta_Time double
---@param Completed boolean
IUltra_Dynamic_Weather_Interface_C['Editor Tick'] = function(self, Editor_Camera_Location, Editor_Camera_Rotation, Delta_Time, Completed) end
---@param Cloud_Coverage double
---@param Wind_Intensity double
---@param Rain double
---@param Snow double
---@param Dust double
---@param Fog double
---@param Thunder_Lightning double
IUltra_Dynamic_Weather_Interface_C['Get Local Weather State Values'] = function(self, Cloud_Coverage, Wind_Intensity, Rain, Snow, Dust, Fog, Thunder_Lightning) end
---@param Location FVector
IUltra_Dynamic_Weather_Interface_C['Get Control Point Location'] = function(self, Location) end
---@param State FUDS_and_UDW_State
---@param Completed boolean
IUltra_Dynamic_Weather_Interface_C['UDW State Apply'] = function(self, State, Completed) end
---@param UDW_State FUDS_and_UDW_State
IUltra_Dynamic_Weather_Interface_C['Get UDW State for Saving'] = function(self, UDW_State) end
---@param UDS AUltra_Dynamic_Sky_C
IUltra_Dynamic_Weather_Interface_C['Initialize Weather'] = function(self, UDS) end


